// winmain.cpp
// Carl Bateman
// Asteroids demo app using 
// Visual C++ Express Edition and GDI

// -- INCLUDES --
#define WIN32_LEAN_AND_MEAN  // just say no to MFC - set as project option
#include <windows.h>         // include important windows stuff
#include "BackBuffer.h"
#include "GameMain.h"

// defines for windows 
#define WINDOW_CLASS_NAME "WINCLASS1"
HWND      hwnd;              // track main window
HINSTANCE hinstance;         // track hinstance
HDC       hdc;               // graphics device context
RECT      rcClient;          // client rectangle area

int cxWindow=646, cyWindow=512;
int cxClient=0, cyClient=0;  //int cxWindow=1000, cyWindow=500;

// -------------
// -- WINPROC --
// -------------
LRESULT CALLBACK WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam) {
	// this is the main message handler of the system
	PAINTSTRUCT		ps;		// used in WM_PAINT
	static HMENU hMenu;

	// what is the message 
	switch(msg) {	
		case WM_CHAR : 
      // forward character to edit
      GameInsertNewTopScore((char)wparam);
			return(0);
		case WM_PAINT : 
			hdc = BeginPaint(hwnd,&ps);
			EndPaint(hwnd,&ps);
			return(0);
		case WM_DESTROY : 
			PostQuitMessage(0);
			return(0);
		default:break;
	} // end switch

	// process any messages that we didn't take care of 
	return (DefWindowProc(hwnd, msg, wparam, lparam));
} // end WinProc

// -------------
// -- WINMAIN --
// -------------
int WINAPI WinMain(	HINSTANCE hinstance, HINSTANCE hprevinstance,
					          LPSTR lpcmdline,     int ncmdshow)
{
	WNDCLASSEX winclass; // this will hold the class we create
	MSG				 msg;		   // generic message

	// first fill in the window class stucture
	winclass.cbSize         = sizeof(WNDCLASSEX);
	winclass.style					= NULL;
	winclass.lpfnWndProc		= WindowProc;
	winclass.cbClsExtra			= 0;
	winclass.cbWndExtra			= 0;
	winclass.hInstance			= hinstance;
	winclass.hIcon					= LoadIcon(NULL, IDI_APPLICATION);
	winclass.hCursor				= LoadCursor(NULL, IDC_ARROW); 
	winclass.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	winclass.lpszMenuName		= NULL;
	winclass.lpszClassName	= WINDOW_CLASS_NAME; 
	winclass.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);

	// register the window class
	if (!RegisterClassEx(&winclass))
		return(0);

	// create the window
	if (!(hwnd = CreateWindowEx(
							 NULL,														// extended style
							 WINDOW_CLASS_NAME,						    // class
							 "BackBuffer - Part1",            // title
							 WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_VISIBLE, //WS_OVERLAPPEDWINDOW
					 		 CW_USEDEFAULT, CW_USEDEFAULT,	  // initial top left, right
							 cxWindow, cyWindow,              // initial width,height
							 NULL,	                          // handle to parent  
							 NULL,	                          // handle to menu
							 hinstance,                       // handle to instance of this application
							 NULL)))	                        // extra creation parms
	return(0);

	AddFontResource("LCDMN___.TTF");

  GameInit();

	// enter main event loop
  while(TRUE)	{ // test if there is a message in queue, if so get it
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE)) { 
      if (msg.message == WM_QUIT)	 // test if this is a quit
        {	break; }
			TranslateMessage(&msg);	// translate any accelerator keys		
			DispatchMessage(&msg);	// send the message to the window proc
		}    
    // main game processing goes here
    GameMain();
	} 
  GameExit();

	RemoveFontResource("LCDMN___.TTF");

  ReleaseDC(hwnd, hdc);
	return(msg.wParam);	// return to Windows like this
} // end WinMain