#include "ShipOutline.h"

ShipOutline::ShipOutline() {
}

ShipOutline::~ShipOutline() {
}

void ShipOutline::setMesh(Mesh* newMesh) {
  this->m_mesh = newMesh;
}

std::vector<std::vector<POINT>> ShipOutline::Lines2d() {
  // get the points
  std::vector<D3DVECTOR> meshD3D(m_mesh->m_points3d.size());

  // displace the points
  for(unsigned int i = 0; i < meshD3D.size(); i++) {
		meshD3D[i].x = m_mesh->m_points3d[i].x;
		meshD3D[i].y = m_mesh->m_points3d[i].y;
		meshD3D[i].x += Position.x;
		meshD3D[i].y += Position.y;
  }
        
  // build the mesh
  std::vector<std::vector<POINT>> meshes(1);

  for(size_t j=0; j < 1; j++) {
    std::vector<POINT> mesh(m_mesh->m_polys[j].size());
		
    for(size_t i=0; i < this->m_mesh->m_polys[j].size(); i++) {
			mesh[i].x = meshD3D[this->m_mesh->m_polys[j][i]].x;
			mesh[i].y = meshD3D[this->m_mesh->m_polys[j][i]].y;
		}
    meshes[j] = mesh;
	}

  return meshes;
}
