#pragma once
#include "model.h"

class Ship : public Model {
public:
  Ship();
  ~Ship();

	const static std::string Name() { return "ship"; } ;
  void Init();
  void Update(DWORD dwTime);
  void Rotate(DWORD dwTime);
	void SetAngularVelocity(bool leftKey, bool rightKey, bool snap);
	bool FireMissile();
	static Mesh* GetMeshData();
  std::vector<std::vector<POINT>> Ship::Lines2d();
  void Accelerate(bool accelerate, DWORD dwTime);
  void Rotate();

  D3DVECTOR Acceleration;
  unsigned int NumMissiles;
  int ShipRegenerationTime;

private:
	static D3DVECTOR shipPoints[];
	static int shipPoly[];
  unsigned int Snap;
  int RechargeCycle;
  int ReloadCycle;

};
