#include "mesh.h"
#include "IModel.h"
#include "Functions.h"

#pragma once

class Model : public IModel {  
public:
  Model();
  virtual ~Model();

  // methods //
  void setMesh(Mesh* newMesh);
  virtual std::vector<std::vector<POINT>> Model::Lines2d();
  virtual void Rotate(DWORD dwTime);
  virtual void Update(DWORD dwTime);

  // data //
	D3DVECTOR UpperBound;
  D3DVECTOR LowerBound;
  double BoundingRadius;
  D3DVECTOR Position;
  D3DVECTOR Velocity;
  int Orientation; 
  float AngularVelocity;
	bool Dead;

	// implementation detail
	bool same (const Model &rh) const {
		return (this == &rh);
	};

  static D3DVECTOR PositionLimit;
};
