#include "Model.h"

Model::Model() {
	Velocity = D3DVECTOR(0,0,0);
	UpperBound = D3DVECTOR(0,0,0);
	LowerBound = D3DVECTOR(0,0,0);
  Position = D3DVECTOR(0, 0, 0);
  Orientation = 0;
  AngularVelocity = 0.0;
	Dead = false;
}

Model::~Model() {
}

D3DVECTOR Model::PositionLimit;

void Model::setMesh(Mesh* newMesh) {
  this->m_mesh = newMesh;
  // find upper and lower bounds
  UpperBound = m_mesh->UpperBound();
  LowerBound = m_mesh->LowerBound();
  BoundingRadius = m_mesh->BoundingRadius();
}

std::vector<std::vector<POINT>> Model::Lines2d() {
  // get the points
  std::vector<D3DVECTOR> meshD3D(m_mesh->m_points3d.size());

  // rotate and displace the points
  for(unsigned int i = 0; i < meshD3D.size(); i++) {
		meshD3D[i].x = double(m_mesh->m_points3d[i].x) * cos(PI/180 * Orientation) - double(m_mesh->m_points3d[i].y) * sin(PI/180 * Orientation);
		meshD3D[i].y = double(m_mesh->m_points3d[i].y) * cos(PI/180 * Orientation) + double(m_mesh->m_points3d[i].x) * sin(PI/180 * Orientation);
		meshD3D[i] += Position;
  }
      
  std::vector<std::vector<POINT>> meshes(this->m_mesh->m_polys.size());
  
  // build the meshes
  for(size_t j=0; j < this->m_mesh->m_polys.size(); j++) {
    std::vector<POINT> mesh(m_mesh->m_polys[j].size());
		
    for(size_t i=0; i < this->m_mesh->m_polys[j].size(); i++) {
			mesh[i].x = meshD3D[this->m_mesh->m_polys[j][i]].x;
			mesh[i].y = meshD3D[this->m_mesh->m_polys[j][i]].y;
		}
    meshes[j] = mesh;
	}

  return meshes;
}

void Model::Rotate(DWORD dwTime) {
	this->Orientation += this->AngularVelocity * dwTime;

  if(abs(this->Orientation) > 180)
		this->Orientation -= sgn(this->Orientation ) * 360;
}

void Model::Update(DWORD dwTime) {
  this->Position = this->Position + this->Velocity * dwTime;
  this->Rotate(dwTime);

  // wrap round model positions
	if(this->Position.x < -PositionLimit.x)
    this->Position.x = this->Position.x + PositionLimit.x * 2;
  else if(this->Position.x > PositionLimit.x)
    this->Position.x = this->Position.x - PositionLimit.x * 2;

  if(this->Position.y < -PositionLimit.y)
    this->Position.y = this->Position.y + PositionLimit.y * 2;
  else if(this->Position.y > PositionLimit.y)
    this->Position.y = this->Position.y - PositionLimit.y * 2;
};
//bool Model::same (const Model &rh) const {
	//	return (this == &rh);
	//};
