#include "Missile.h"

Missile::Missile() {
}

Missile::Missile(Model model) {
  this->Lifetime = 1500;
	this->Speed = 0.15;
  this->Dead = false;

  this->Position = model.Position;
  this->Orientation = model.Orientation;
  this->Velocity = model.Velocity;
  this->Velocity.x -= sin(PI/180 * model.Orientation) * this->Speed;
  this->Velocity.y += cos(PI/180 * model.Orientation) * this->Speed;
};

Missile::~Missile() {
}

Mesh* Missile::GetMeshData() {
	static D3DVECTOR points[] = {  D3DVECTOR(-0.25, -0.5, 0.0),
													       D3DVECTOR( 0.25, -0.5, 0.0),
													       D3DVECTOR( 0.25,  0.5, 0.0),
													       D3DVECTOR(-0.25,  0.5, 0.0),
												      };
	static int poly[] = {0,1,2,3,0};

	Mesh* mesh = new Mesh;

	mesh->AddPoints(points, sizeof(points)/sizeof(points[0]));
  mesh->AddPoly(poly, sizeof(poly)/sizeof(int));

	return mesh;
};

void Missile::Update(DWORD dwTime) {
  Model::Update(dwTime);
  this->Lifetime -= dwTime;
  if(this->Lifetime < 1)
    this->Dead = true;
};