#pragma once
#include <vector>
#define D3D_OVERLOADS // switch on overloaded functions
#include <d3d.h>		  // include data types
const float PI = 3.141592654f;

class Mesh {
public:
  Mesh();
  ~Mesh();

  // accessors
  void AddPoint(D3DVECTOR newPoint);
  void AddLine(int newStart, int newEnd);
  void AddPoints(D3DVECTOR newPoints[], int size);
  void AddLines(int newLineEnds[]);
  void AddPoly(int newLineEnds[], int size);
  void SetMesh(D3DVECTOR newPoints[], int newLineEnds[]);

  D3DVECTOR UpperBound();
  D3DVECTOR LowerBound();
  double BoundingRadius();
  virtual std::vector<std::vector<POINT>> Lines2d();
  std::vector <int> Points2d();
  
  // properties
  std::vector <D3DVECTOR> m_points3d;
  std::vector <std::vector <int>> m_polys;
private:
  std::vector <int> m_lines;
  std::vector <POINT> m_points2d;
};
