#include "Mesh.h"

Mesh::Mesh() {
}

Mesh::~Mesh() {
}

D3DVECTOR Mesh::UpperBound() {
	D3DVECTOR Bound = D3DVECTOR(0,0,0);
	for(int i = 0; i < m_points3d.size(); i++)
		Bound = Maximize(Bound, m_points3d[i]);
	return (Bound);
};

D3DVECTOR Mesh::LowerBound() {
	D3DVECTOR Bound = D3DVECTOR(0,0,0);
	for(int i = 0; i < m_points3d.size(); i++)
		Bound = Minimize(Bound, m_points3d[i]);
	return (Bound);
};

double Mesh::BoundingRadius() {
	D3DVECTOR lBound = this->LowerBound();
	D3DVECTOR uBound = this->UpperBound();
	return (Magnitude(uBound - lBound)/2);
};

void Mesh::AddPoint(D3DVECTOR newPoint){
  m_points3d.push_back(newPoint);
};

void Mesh::AddLine(int newStart, int newEnd){
  m_lines.push_back(newStart);
  m_lines.push_back(newEnd);
};

void Mesh::AddPoints(D3DVECTOR newPoints[], int size){
  for(int i = 0; i < size; i++)
    m_points3d.push_back(newPoints[i]);
};

void Mesh::AddPoly(int newLineEnds[], int size) {
	std::vector<int> newPoly(size);
	for (int i=0; i < size; i++){
    newPoly[i] = newLineEnds[i];
  }
	m_polys.push_back(newPoly);
};

void Mesh::SetMesh(D3DVECTOR newPoints[], int newLineEnds[]){
};

std::vector<std::vector<POINT>> Mesh::Lines2d() {
  // returns a list of points as 2d POINT

  std::vector<std::vector<POINT>> meshes;
	//for (int j=0;j < this->m_polys.size();j++) {
	//	std::vector<POINT> mesh;
	//	for (int i=0;i < this->m_polys.size();i++) {
	//		POINT pt;
	//		pt.x = m_points3d[j][m_polys[i]].x; 
	//		pt.y = m_points3d[j][m_polys[i]].y;
	//		mesh.push_back(pt);
	//	}
	//	meshes.push_back(mesh);
	//}
  return (meshes);
}
