#define D3D_OVERLOADS // switch on overloaded functions
#include <d3d.h>		  // include data types
#include "mesh.h"

#pragma once

class IModel {
public:
  IModel();
  virtual ~IModel() = 0;

  // methods //
  void setMesh(Mesh* newMesh);
  std::vector<POINT> Lines2d();

  // data //
	D3DVECTOR UpperBound;
  D3DVECTOR LowerBound;
  double BoundingRadius;
  D3DVECTOR Position;
  D3DVECTOR Velocity;
  int Orientation; 
  float AngularVelocity;

protected:
  // members
  bool invalid;
  Mesh* m_mesh;
};
