#pragma once
#include <string>
#include <typeinfo>
#include <vector>
#include <map>
#include <algorithm>
#include <sstream>
#include <fstream>
#include <iostream>

#include "Functions.h"
#include "Model.h"
#include "Asteroid.h"
#include "Ship.h"
#include "ShipOutline.h"
#include "BackBuffer.h"
#include "Missile.h"
#include "Player.h"
#include "Debris.h"

#define KEYDOWN(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 1 : 0)
#define KEYUP(vk_code)   ((GetAsyncKeyState(vk_code) & 0x8000) ? 0 : 1)

// forward declare functions
void CheckCollisions();
void CheckKeyboard();
void GameExit();
void GameInit();
void GameMain();
void GameOver();
void GamePause();
void GameShowHelp();
void GameShowScores();
void GamePlayGame();
void GameInsertNewTopScore(char newChar);
void SetState();
void DrawAllModels();
void UpdateAllModels();
void GameReset();
void AddAsteroids();
void ConfirmQuit();
bool RemoveDeadModels(Model* model);
void ShatterAsteroid(Asteroid& asteroid);

