#include "Debris.h"

Debris::Debris() {
}

Debris::~Debris() {
}

unsigned int Debris::NextDebrisShapeIndex = 0;

Debris::Debris(Mesh* newMesh) {
  this->m_mesh = newMesh;

  DebrisShapeIndex = 0;
  if (m_mesh != NULL)
    DebrisShapeIndex = NextDebrisShapeIndex;

  NextDebrisShapeIndex++;
  NextDebrisShapeIndex %= m_mesh->m_polys.size();

  //this->Lifetime = 1500;
	this->Speed = 0.15;
  this->Dead = false;
  double rdx = RanDouble(0.05, 0.1);
  rdx = sgn(RanDouble(-1,1)) * rdx;

  this->AngularVelocity = rdx;
};

Mesh* Debris::GetMeshData() {
	static D3DVECTOR points[] = { D3DVECTOR(    0.0, 8.0, 0.0),   // 0
															  D3DVECTOR(   -6.0,-8.0, 0.0),   // 1
															  D3DVECTOR(    0.0,-1.0, 0.0),   // 2
															  D3DVECTOR(    6.0,-8.0, 0.0),   // 3
	};
	static int poly01[] = {0,1};
	static int poly02[] = {1,2};
	static int poly03[] = {2,3};
	static int poly04[] = {3,0};

	Mesh* mesh = new Mesh;

	mesh->AddPoints(points, sizeof(points)/sizeof(points[0]));
  mesh->AddPoly(poly01, sizeof(poly01)/sizeof(int));
  mesh->AddPoly(poly02, sizeof(poly02)/sizeof(int));
  mesh->AddPoly(poly03, sizeof(poly03)/sizeof(int));
  mesh->AddPoly(poly04, sizeof(poly04)/sizeof(int));

	return mesh;
};

std::vector<std::vector<POINT>> Debris::Lines2d() {
  // get the points
  std::vector<D3DVECTOR> meshD3D(m_mesh->m_points3d.size());

  // rotate and displace the points
  for(unsigned int i = 0; i < meshD3D.size(); i++) {
		meshD3D[i].x = double(m_mesh->m_points3d[i].x) * cos(PI/180 * Orientation) - double(m_mesh->m_points3d[i].y) * sin(PI/180 * Orientation);
		meshD3D[i].y = double(m_mesh->m_points3d[i].y) * cos(PI/180 * Orientation) + double(m_mesh->m_points3d[i].x) * sin(PI/180 * Orientation);
		meshD3D[i].x += Position.x;
		meshD3D[i].y += Position.y;
  }
      
  std::vector<std::vector<POINT>> meshes(1);
  
  // build the meshes
  unsigned int j = DebrisShapeIndex;
  std::vector<POINT> mesh(m_mesh->m_polys[j].size());
	
  for(size_t i=0; i < this->m_mesh->m_polys[j].size(); i++) {
		mesh[i].x = meshD3D[this->m_mesh->m_polys[j][i]].x;
		mesh[i].y = meshD3D[this->m_mesh->m_polys[j][i]].y;
	}
  meshes[0] = mesh;

  return meshes;
}
