// BackBuffer class definition
// Carl Bateman based on snippets by Geoff Howland
// October 2005
#pragma once
#include <windows.h>
#define D3D_OVERLOADS // switch on overloaded functions
#include <d3d.h>		  // include data types
#include <vector>
#include <string>

class BackBuffer{
public:
  // nice classes have a ctor, dtor, copy &
  BackBuffer() {};  // over ride default constructor
  ~BackBuffer() {}; // over ride default destructor

  //methods
  void Create();
  void Clear();
  void Destroy();
	void Display();
  void DrawLine(int x1, int y1, int x2, int y2);

	void DrawPolyPolyLine(std::vector<std::vector<D3DVECTOR>> pts);
	void DrawPolyPolyLine(std::vector<std::vector<POINT>> pts);

  void DrawPolyLine(std::vector<D3DVECTOR> pts);
  void DrawPolyLine(std::vector<POINT> pts);

  void DrawPolygon(std::vector<D3DVECTOR> pts);
  void DrawPolygon(std::vector<POINT> pts);
  //void DrawPolyLine(D3DPOINT[]);

	void BackBuffer::DrawMsg(RECT* textArea, long height, std::string msg, unsigned int size, UINT uFormat, bool Transparent = false);

  // simple accessors
  int Height() const
  { return m_iHeight; };
  int Width() const
  { return m_iWidth; };
  BYTE* BackData()
  { return m_bmpBackData; };

protected:
	// generic back buffer info
	BYTE* m_bmpBackData;
	int m_iHeight;
  int m_iWidth;

  // MS Windows specific data
  BITMAP m_bitmap;            // The BITMAP structure defines the type, width, height, color format, and bit values of a bitmap
	BITMAPINFO m_BitmapInfo;    // The BITMAPINFO structure defines the dimensions and color information for a Win32 DIB
	HBITMAP m_hBitmap;
	HDC m_hdcBuffer;
	HDC m_hdcScreen;

  HPEN m_currentPen;
	HFONT g_hfFontSmall;
	HFONT g_hfFontMedium;
	HFONT g_hfFontLarge;
};
