// BackBuffer class implementation
// Carl Bateman based on snippets by Geoff Howland
// October 2005

#include "BackBuffer.h"

void BackBuffer::Create () {
	HWND hwndActive = GetActiveWindow();
	if(hwndActive == NULL)
		return;
	RECT lpRect;
	GetClientRect(hwndActive, &lpRect);
	m_iWidth = lpRect.right ;
	m_iHeight = lpRect.bottom ;
	// Set up BitmapInfoHeader
	m_BitmapInfo.bmiHeader.biBitCount = 24;
	m_BitmapInfo.bmiHeader.biClrImportant = 0;
	m_BitmapInfo.bmiHeader.biClrUsed = 0;
	m_BitmapInfo.bmiHeader.biCompression = BI_RGB;
	m_BitmapInfo.bmiHeader.biHeight = -m_iHeight;
	m_BitmapInfo.bmiHeader.biPlanes = 1;
	m_BitmapInfo.bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
	m_BitmapInfo.bmiHeader.biSizeImage = m_iWidth * m_iHeight * (m_BitmapInfo.bmiHeader.biBitCount / 8);
	m_BitmapInfo.bmiHeader.biWidth = m_iWidth;
	m_BitmapInfo.bmiHeader.biXPelsPerMeter = 0;
	m_BitmapInfo.bmiHeader.biYPelsPerMeter = 0;

	m_BitmapInfo.bmiColors[0].rgbRed = 0;
	m_BitmapInfo.bmiColors[0].rgbGreen = 0;
	m_BitmapInfo.bmiColors[0].rgbBlue = 0;
	m_BitmapInfo.bmiColors[0].rgbReserved = 0;

	// Create the DIB section with CreateDIBSection
	m_hdcScreen = GetDC(hwndActive);
	m_hdcBuffer      = CreateCompatibleDC(m_hdcScreen); 
	m_hBitmap        = CreateDIBSection (m_hdcBuffer, (BITMAPINFO *) &m_BitmapInfo, 0, (void **) &m_bmpBackData, NULL, 0);
	GetObject (m_hBitmap, sizeof (BITMAP), &m_bitmap);
	m_bmpBackData    = (BYTE*) m_bitmap.bmBits;
	SelectObject (m_hdcBuffer, m_hBitmap);

  m_currentPen = CreatePen(PS_SOLID, 1, RGB(0,255,0));
	SelectObject(m_hdcBuffer, m_currentPen);

	long lfHeight;
	
	lfHeight = -MulDiv(22, GetDeviceCaps(m_hdcBuffer, LOGPIXELSY), 72);

	g_hfFontSmall = CreateFont(lfHeight, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, FIXED_PITCH , "LCDMono Normal");
	lfHeight = -MulDiv(12, GetDeviceCaps(m_hdcBuffer, LOGPIXELSY), 72);
	g_hfFontMedium = CreateFont(lfHeight*2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, FIXED_PITCH , "LCDMono Normal");
	g_hfFontLarge = CreateFont(lfHeight*3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "LCDMono Normal");

	SetBkColor(m_hdcBuffer, RGB(0,0,0));
	SetTextColor(m_hdcBuffer, RGB(255,64,64));
}

void BackBuffer::Destroy () {
	// if we have a bitmap destroy
	if (m_hBitmap != NULL) {
		DeleteObject (m_hBitmap);
		m_hBitmap = NULL;
		DeleteDC (m_hdcBuffer);
		DeleteDC (m_hdcScreen);
	}
  //SelectObject(m_hdcBuffer, hPenOld); // don't need this as destroying... d'oh
  DeleteObject(m_currentPen);
  DeleteObject(g_hfFontSmall);
  DeleteObject(g_hfFontMedium);
  DeleteObject(g_hfFontLarge);
}

void BackBuffer::Display() {
	// Display from CreateDIBSection creation
	BitBlt (m_hdcScreen, 0, 0, m_bitmap.bmWidth, m_bitmap.bmHeight, m_hdcBuffer, 0, 0, SRCCOPY);
}

void BackBuffer::DrawLine(int x1, int y1, int x2, int y2) {
  MoveToEx(m_hdcBuffer, x1, y1, NULL);
  LineTo(m_hdcBuffer, x2, y2);
}

void BackBuffer::DrawPolyPolyLine(std::vector<std::vector<D3DVECTOR>> pts) {
  size_t limit = pts.size();
  for (unsigned int i=0;i < limit-1;i+=1) {
    DrawPolyLine(pts[i]);
  }
}

void BackBuffer::DrawPolyLine(std::vector<D3DVECTOR> pts) {
  size_t limit = pts.size();
  for (unsigned int i=0;i < limit-1;i+=1) {
    MoveToEx(m_hdcBuffer, pts[i].x + m_iWidth / 2, pts[i].y + m_iHeight / 2, NULL);
    LineTo(m_hdcBuffer, pts[i+1].x + m_iWidth / 2, pts[i+1].y + m_iHeight / 2);
  }
}

void BackBuffer::DrawPolyPolyLine(std::vector<std::vector<POINT>> pts) {
  size_t limit = pts.size();
  for (unsigned int i=0;i < limit;i++) {
    DrawPolyLine(pts[i]);
  }
}

void BackBuffer::DrawPolyLine(std::vector<POINT> pts) {
  size_t limit = pts.size();
  unsigned int xOffset = m_iWidth / 2;
  unsigned int yOffset = m_iHeight / 2;

  for (unsigned int i=0;i < limit-1;i+=1) {
    MoveToEx(m_hdcBuffer, xOffset + pts[i].x, yOffset - pts[i].y, NULL);
    LineTo(m_hdcBuffer, xOffset + pts[i+1].x, yOffset - pts[i+1].y);
  }
}

void BackBuffer::DrawPolygon(std::vector<POINT> pts) {
  size_t limit = pts.size();
  MoveToEx(m_hdcBuffer, pts[0].x + m_iWidth / 2, pts[0].y + m_iHeight / 2, NULL);
  for (unsigned int i=0;i < limit;i+=1) {
    LineTo(m_hdcBuffer, pts[i].x + m_iWidth / 2, pts[i].y + m_iHeight / 2);
  }
  LineTo(m_hdcBuffer, pts[0].x + m_iWidth / 2, pts[0].y + m_iHeight / 2);
}

void BackBuffer::Clear() {
	unsigned long* Pix;
  long l;

	Pix = (unsigned long *) &m_bmpBackData[0];
  for(l=0;l<m_iHeight*m_iWidth*3/4;l++) {
		Pix[l]=0;
	}
}

void BackBuffer::DrawMsg(RECT* textArea, long height, std::string msg, unsigned int size, UINT uFormat, bool Transparent) {
	const char * szMsg = msg.c_str();

	HFONT hfOld;// = (HFONT)SelectObject(m_hdcScreen, hf);

	switch (size) {
		case 0:
			hfOld = (HFONT)SelectObject(m_hdcBuffer, g_hfFontSmall);
			break;
		case 2:
			hfOld = (HFONT)SelectObject(m_hdcBuffer, g_hfFontLarge);
			break;
		default:
			hfOld = (HFONT)SelectObject(m_hdcBuffer, g_hfFontMedium);
	}

	if(Transparent)
		SetBkMode(m_hdcBuffer, TRANSPARENT);
	else
		SetBkMode(m_hdcBuffer, OPAQUE);


	DrawText(m_hdcBuffer, szMsg, -1, textArea, uFormat);//DT_WORDBREAK | DT_CENTER | DT_VCENTER);

	SelectObject(m_hdcScreen, hfOld);
}