#include "Asteroid.h"

Asteroid::Asteroid() {
	scale = 1;
  AsteroidShapeIndex = rand() % 2;
}
unsigned int Asteroid::numAsteroids = 0;

Asteroid::Asteroid(Mesh* newMesh) {
  this->m_mesh = newMesh;
  // find upper and lower bounds
  UpperBound = m_mesh->UpperBound();
  LowerBound = m_mesh->LowerBound();
  BoundingRadius = m_mesh->BoundingRadius();

  double rdx = RanDouble(0.05, 0.1);
  rdx = sgn(RanDouble(-1,1)) * rdx;

  AngularVelocity = rdx;

  double min = -0.06;
  double max = 0.06;

  Velocity = D3DVECTOR(RanDouble(min, max), RanDouble(min, max), 0);

	scale = 1;
  AsteroidShapeIndex = 0;
  if (m_mesh != NULL)
    AsteroidShapeIndex = rand() % m_mesh->m_polys.size();

  ++numAsteroids;
}

Asteroid::~Asteroid() {
  --numAsteroids;
}

void Asteroid::Shatter(Asteroid Asteroid) {
}

Mesh* Asteroid::GetMeshData() {
  static D3DVECTOR points[] = { D3DVECTOR(-15.0,-15.0, 0.0), // 0
                         D3DVECTOR( 20.0,-20.0, 0.0), // 1
                         D3DVECTOR( 15.0, 15.0, 0.0), // 2
                         D3DVECTOR(-15.0, 15.0, 0.0), // 3
                         D3DVECTOR(  0.0,  5.0, 0.0), // 4
                         
                         D3DVECTOR(-15.0,-20.0, 0.0), // 5
                         D3DVECTOR( 15.0,-15.0, 0.0), // 6
                         D3DVECTOR( 15.0, 15.0, 0.0), // 7
                         D3DVECTOR(-15.0, 20.0, 0.0), // 8
                         D3DVECTOR(-25.0,  0.0, 0.0), // 9
                         
                         D3DVECTOR(-25.0, -6.0, 0.0), // 10
                         D3DVECTOR( -9.0,-25.0, 0.0), // 11
                         D3DVECTOR( -3.0,-13.0, 0.0), // 12
                         D3DVECTOR(  2.0,-25.0, 0.0), // 13
                         D3DVECTOR( 18.0,-13.0, 0.0), // 14
                         D3DVECTOR(  2.0, -1.0, 0.0), // 15
                         D3DVECTOR( 18.0, -1.0, 0.0), // 16
                         D3DVECTOR( 18.0, 12.0, 0.0), // 17
                         D3DVECTOR( -2.0, 24.0, 0.0), // 18
                         D3DVECTOR( -9.0, 24.0, 0.0), // 19
                         D3DVECTOR(-25.0, 10.0, 0.0), // 20
                       };
	static int poly01[] = {0,1,2,3,4,0};
	static int poly02[] = {5,6,7,8,9,5};
	static int poly03[] = {10,11,12,13,14,15,16,17,18,19,20,10};

	Mesh* mesh = new Mesh;

	mesh->AddPoints(points, sizeof(points)/sizeof(points[0]));
  mesh->AddPoly(poly01, sizeof(poly01)/sizeof(int));
  mesh->AddPoly(poly02, sizeof(poly02)/sizeof(int));
  mesh->AddPoly(poly03, sizeof(poly03)/sizeof(int));

	return mesh;
}

void Asteroid::Scale(int newVal) {
  scale = newVal;
  BoundingRadius = this->m_mesh->BoundingRadius() / scale;
};

std::vector<std::vector<POINT>> Asteroid::Lines2d() {
  // get the points
  std::vector<D3DVECTOR> meshD3D(m_mesh->m_points3d.size());

  // rotate and displace the points
  for(unsigned int i = 0; i < meshD3D.size(); i++) {
		meshD3D[i].x = double(m_mesh->m_points3d[i].x) * cos(PI/180 * Orientation) - double(m_mesh->m_points3d[i].y) * sin(PI/180 * Orientation);
		meshD3D[i].y = double(m_mesh->m_points3d[i].y) * cos(PI/180 * Orientation) + double(m_mesh->m_points3d[i].x) * sin(PI/180 * Orientation);
		meshD3D[i] /= scale;
		meshD3D[i] += Position;
  }
      
  std::vector<std::vector<POINT>> meshes(1);
  
  // build the meshes
  unsigned int j = AsteroidShapeIndex;
    std::vector<POINT> mesh(m_mesh->m_polys[j].size());
		
    for(size_t i=0; i < this->m_mesh->m_polys[j].size(); i++) {
			mesh[i].x = meshD3D[this->m_mesh->m_polys[j][i]].x;
			mesh[i].y = meshD3D[this->m_mesh->m_polys[j][i]].y;
		}
    meshes[0] = mesh;
	//}

  return meshes;
}
  